package cn.com.duiba.kjy.api.params.billing;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/12/10 19:36
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BillingClockTicketDrawSearchParam extends PageQuery {

    private static final long serialVersionUID = -4957500257474566708L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 补卡卷领取配置id
     */
    private Long reissueTicketConfId;

    /**
     * 领取状态
     * @see cn.com.duiba.kjy.api.enums.billing.BillingClockDrawStateEnum
     */
    private Integer drawState;

    /**
     * 领取来源
     * @see cn.com.duiba.kjy.api.enums.billing.BillingClockDrawSourceEnum
     */
    private Integer drawSource;

}
