package cn.com.duiba.kjy.api.enums.seller;

/**
 * 用户转发类型枚举
 * @author 吴文哲
 * @date 2020-02-22 15:04
 **/
public enum UserForwardTypeEnum {

    UNKNOW(0,"未知"),
    PERSONAL_OR_GROUP(1,"个人/微信群"),
    FRIENDS_GROUP(2,"朋友圈"),
    ;

    /**
     * 转发类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    UserForwardTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public static UserForwardTypeEnum getByType(Integer type) {
        for (UserForwardTypeEnum enumVal : UserForwardTypeEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
