package cn.com.duiba.kjy.api.params.crm;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhanghuifeng
 * date 2020/12/7-10:43
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CrmCompanyQryParam extends PageQuery {
    private static final long serialVersionUID = -5456097420134376293L;

    /**
     * 公司等级
     * @see cn.com.duiba.kjy.api.enums.crm.CrmCompanyGradeEnum
     */
    private Integer companyGrade;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 创建来源 1后台创建,2销售创建
     */
    private Integer createType;

    /**
     * 上级公司ID
     */
    private Long parentCompanyId;

    /**
     * 公司id列表
     */
    private List<Long> companyIds;
}
