package cn.com.duiba.kjy.api.enums.wakeup;

import java.util.Objects;

/**
 * 唤醒推送状态枚举
 * @Author chentiecheng
 * @Date 2020/7/9 10:58 上午
 */
public enum WakeUpStatusEnum {
    NOT_ENABLE(1, "未启用"),
    ENABLE(2, "启用"),
    ;
    private Integer code;
    private String desc;

    WakeUpStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code获取枚举
     * @param code
     * @return
     */
    public static WakeUpStatusEnum getByCode(Integer code){
        if(Objects.isNull(code)){
            return null;
        }
        for(WakeUpStatusEnum enums : WakeUpStatusEnum.values()){
            if(Objects.equals(enums.getCode(),code)){
                return enums;
            }
        }
        return null;
    }
}
