package cn.com.duiba.kjy.api.dto.wx.tag;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信公众号用户标签表
 * @author kjj mybatis generator 
 * @date 2020-09-29
 */
@Data
public class WxTagDto implements Serializable {
     
    private static final long serialVersionUID = 16013593967005082L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标签所属公众号主键，tb_official_accounts.id
     */
    private Long oaId;

    /**
     * 标签类型，tb_wx_tag_type.id
     */
    private Long tagTypeId;

    /**
     * 微信标签ID
     */
    private String wxTagId;

    /**
     * 微信标签名称
     */
    private String wxTagName;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}