package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2020/9/22-16:11
 */
public enum BillingPlanDateTypeEnum {

    DAY(1, "日"),
    WEEKLY(2, "周"),

    ;

    private Integer code;
    private String desc;

    BillingPlanDateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingPlanDateTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingPlanDateTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingPlanDateTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
