package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/1/7 3:43 PM
 */
public enum  KjjBizTypeEnum {

    RED_PACKET(1, "销售员红包"),
    ;

    private Integer code;
    private String desc;

    KjjBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, KjjBizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(KjjBizTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static KjjBizTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
