package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerCustomerTag.SellerCustomerTagCountDto;
import cn.com.duiba.kjy.api.dto.sellerCustomerTag.SellerCustomerTagDto;
import cn.com.duiba.kjy.api.params.seller.UpdateCustomerSingleTagParams;

import java.util.List;

/**
 * 销售客户标签关联管理
 * @Author chentiecheng
 * @Date 2020/6/8 5:02 下午
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerTagService {
    /**
     * 根据customerId获取 客户标签列表
     * @param customerId
     * @return
     */
    List<SellerCustomerTagDto> getCustomerTagByCustomerId(Long customerId);

    /**
     * 根据customerI统计总数
     * @param customerId
     * @return
     */
    Integer countByCustomerId(Long customerId);

    /**
     * 新增更新客户标签
     * @param sellerId 销售id
     * @param customerId
     * @param tagIds
     * @return
     */
    Boolean addOrUpdateCustomerTag(Long sellerId,Long customerId,List<Long> tagIds);

    /**
     * 获取当前代理人每个标签下的客户数
     * @param sellerId
     * @return
     */
    List<SellerCustomerTagCountDto> getCustomerTagCountGroupByTagId(Long sellerId);

    /**
     * 新增删除单个标签
     * @param param
     * @return
     */
    Boolean addOrDeleteSingleTag(UpdateCustomerSingleTagParams param);
}
