package cn.com.duiba.kjy.api.remoteservice.wx.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.wx.tag.WxTagTypeDto;

import java.util.List;

/**
 * 微信标签类型
 * @author lizhi
 * @date 2020/10/10 2:33 PM
 */
@AdvancedFeignClient
public interface RemoteOaWxTagTypeService {

    /**
     * 获取所有标签类型
     * @return 所有标签类型
     */
    List<WxTagTypeDto> getAllTagType();

    /**
     * 根据主键集合查询
     * @param ids 主键
     * @return 标签类型
     */
    List<WxTagTypeDto> selectByIds(List<Long> ids);

    /**
     * 新增标签类型
     * @param dto 标签类型
     * @return 执行结果
     */
    int insert(WxTagTypeDto dto);

    /**
     * 更新标签类型
     * @param dto 标签类型
     * @return 执行结果
     */
    int update(WxTagTypeDto dto);

    /**
     * 删除标签类型
     * @param id 主键
     * @return 执行结果
     */
    int deleted(Long id);
}
