package cn.com.duiba.kjy.api.remoteservice.version;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.version.VersionDto;
import cn.com.duiba.kjy.api.params.version.VersionQueryParam;

import java.util.List;

/**
 * 版本 rpc接口
 * @author 吴文哲
 * @date 2020-04-22 10:14
 **/
@AdvancedFeignClient
public interface RemoteVersionService {

    /**
     * 根据版本id 查询详情
     * @param version
     * @return
     */
    VersionDto selectByVersion(Integer version);

    /**
     * 查询版本列表
     * @return
     */
    List<VersionDto> getVersionList();

    /**
     * 新增版本
     * @return
     */
    Integer  addVersion(VersionDto versionDto);

    /**
     * 更新版本
     * @param updateVersion
     * @return
     */
    Integer updateVersion(VersionDto updateVersion);

    /**
     * 删除 版本
     * @param version
     * @return
     */
    Integer delVersion(Integer version);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(VersionQueryParam param);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<VersionDto> listByCondition(VersionQueryParam param);
}
