package cn.com.duiba.kjy.api.util;


/**
 * Created by dugq on 2019-02-21.
 */
public enum ErrorCode implements ErrorCodeInterface {
    //通用
    DATE_ERROR("990001","数据错误"),
    GET_LOCK_FAIL("990002", "获取分布式锁失败"),
    SYSTEM("999999","系统错误"),

    //00 : 内容
    N000000("000000","内容模块"),
    INSERT_ERROR("000001","内容主表插入失败"),
    CONTENT_EXT_ERROR("000002","内容扩展表插入失败"),
    TARGET_SORT_ERROR("000003","目标位置不存在，目标位置超过了总数"),
    N000004("000004", "内容互动问题数据创建失败"),
    N000005("000005", "内容互动选项创建失败"),
    N000006("000006", "用户互动投票记录创建失败"),
    N000007("000007", "内容互动问题数据修改失败"),
    N000008("000008", "内容互动选项修改失败"),
    N000009("000009", "用户互动投票记录修改失败"),
    N000010("000010", "用户多选项投票记录失败"),
    N000011("000011", "该内容已存在互动"),
    N000012("000012", "老文章ID不能为空"),
    N000013("000013", "新文章ID不能为空"),
    N000014("000014", "新文章ID不能是原来的5个老文章ID"),
    N000015("000015", "新文章ID没有匹配到相应的文章"),
    N000016("000016", "类型只能是文章"),
    N000017("000017", "老文章ID不存在，不能替换成新文章ID"),
    N000018("000018", "销售ID不能为空"),
    N000019("000019", "最上面的文章不能上移"),
    N000020("000020", "最下面的文章不能下移"),
    N000021("000021", "文章不能是已删除状态"),

    //01 销售订单模块
    N010001("010001","更新用户信息错误"),
    N010002("010002","支付记录状态错误"),
    PAY_RECORD_NOT_EXIST("010003","支付记录不存在"),
    SELLER_NOT_EXIST("010005","销售员不存在"),

    //02 用户模块
    N020001("020001","保存用户信息错误"),
    N020002("020002","保存用户扩展信息错误"),
    N020003("020003","更新用户信息错误"),
    N020004("020004","保存用户扩展信息错误"),
    N020005("020005","更新用户扩展信息错误"),

    //03激活码
    ALREADY_USED("030001","激活码已经使用"),
    NOT_SELLER("030002","非销售不能激活"),
    UN_USEFUL("030003","无用的或者非法的激活码"),
    ADD_VIP_TIME("030004","添加vip时间错误"),
    ALREADY_ACTIVATED("030005","该用户已经使用过一次了"),
    ALREADY_VIP("030006","已经是vip了"),
    ALREADY_VIP_TOO_LONG("030007","剩余有效期超过1年不能使用激活码"),

    //04首页分类
    BUSY_MOVING("040001","移动过去频繁"),

    // 05 资料库管理
    N050001("050001", "文章不存在"),
    N050002("050002", "公司不存在"),

    // 06 抽奖活动
    N060001("060001", "没有谢谢参与奖项"),
    N060002("060002", "没有对应的抽奖规则"),
    N060003("060003", "活动不存在或没有开启"),
    N060004("060004", "获取剩余次数失败"),
    N060005("060005", "剩余次数不足"),
    N060006("060006", "奖品配置列表为空"),
    N060007("060007", "根据规则出奖异常"),
    N060008("060008", "奖品中奖次数超过限制"),
    N060009("060009", "没有找到抽奖游戏ID"),
    N060010("060010", "没有找到抽奖游戏"),
    N060011("060011", "获取扣库存处理器失败"),
    N060012("060012", "扣库存失败"),
    N060013("060013", "可中奖列表为空"),
    N060014("060014", "扣库存奖品为null"),
    N060015("060015", "扣库存自定义库存ID为空"),
    N060016("060016", "扣自定义库存失败"),
    N060017("060017", "扣库存奖品详情为空"),
    N060018("060018", "扣库存客集集优惠券奖项ID为空"),
    N060019("060019", "扣客集集优惠券库存失败"),
    N060020("060020", "扣库存客集集奖项ID为空"),
    N060021("060021", "扣客集集库存失败"),
    N060022("060022", "根据出奖规则出奖为空，则出谢谢参与，正常逻辑"),
    N060023("060023", "总概率大于100%"),
    N060024("060024", "抽到的奖品类型错误"),
    N060025("060025", "优惠券扣客集集库存失败"),
    N060026("060026", "保存或更新抽奖游戏失败"),
    N060027("060027", "保存或更新抽奖游戏奖品失败"),
    N060028("060028", "保存或更新抽奖游戏奖品配置失败"),
    N060029("060029", "保存活动与抽奖游戏关系失败"),
    N060030("060030", "暂时不支持的中奖类型"),
    N060031("060031", "保存中奖信息失败"),


    N070001("070001", "缺少推送配置"),

    /**
     * 公司相关
     */
    N080001("080001", "公司信息不存在"),
    N080002("080002", "内容不存在"),
    N080003("080003", "内容不符,添加失败"),
    N080004("080004", "动态新闻已经存在!"),
    N080005("080005", "动态新闻不存在!"),
    N080006("080006", "删除公司动态新闻失败,参数错误!"),
    N080007("080007", "移动公司动态新闻失败,稍后再试!"),
    N080008("080008", "公司下没有动态新闻!"),
    N080009("080009", "内容已删除或未发布!"),
    N080010("080010", "行业还存在绑定公司，不可删除"),

    /**
     * 使用攻略相关
     */
    N090001("090001", "参数错误"),
    N090002("090002", "FAQ分类标签不存在"),
    N090003("090003", "排序错误"),
    N090004("090004", "成功案例不存在"),
    N090005("090005", "FAQ不存在"),
    N090006("090006", "FAQ分类标签名重复!"),
    N090007("090007", "FAQ分类标签排序信息不完整!"),
    N090008("090008", "使用攻略不存在"),

    /**
     * 代理人会员迁移
     */
    N100001("100001", "代理人信息不存在"),
    N100002("100002", "代理人用户信息不存在"),
    N100003("100003", "请检查配置信息"),
    N100004("100004", "非首次付费,无法迁移"),
    N100005("100005", "老用户非会员，无法迁移"),
    N100006("100006", "老用户没有付款成功记录，无法迁移"),
    N100007("100007", "老用户最近的付款成功记录，距今已有些时日，无法迁移"),
    N100008("100008", "老用户存在提现成功记录，无法迁移"),
    N100009("100009", "新用户已经是会员，无法迁移"),
    N100010("100010", "数据更新异常，请联系管理员"),
    N100011("100011", "该用户已经做过迁移,无法重复迁移"),

    /**
     * 客集集用户版本相关
     */
    N110001("110001", "目标版本不存在"),
    N110002("110002", "参数错误"),
    N110003("110003", "目标版本与当前版本相同"),
    N110004("110004", "不存在可用的版本"),
    N110005("110005", "当前不存在正在使用的版本"),
    N110006("110006", "当前版本非会员,无法切换"),
    N110007("110007", "会员用户只能在付费版本简互相切换"),
    N110008("110008", "抱歉!您尚未成为代理人！无法切换版本"),

    /**
     * 首页弹层
     */
    N120001("120001", "当前弹窗个启用中，不可删除"),

    /**
     * 公众号文章
     */
    N130001("130001", "文章已添加至公众号下"),
    N130002("130002", "只能锁前10篇文章"),
    N130003("130003", "移动位置不存在"),
    N130004("130004", "移动距离不能超过20"),
    N130005("130005", "目标位已被锁定位置"),
    N130006("130006", "非法移动"),


    /**
     * 退款相关
     */
    N140001("140001", "存在待审核记录"),
    N140002("140002", "累计提现已达上线，请更改提现金额"),
    N140003("140003", "付款时间超过30天，不能申请退款"),
    N140004("140004", "可退款金额计算失败，冲重新尝试"),
    N140005("140005", "该笔订单可退金额不足，请重新确认金额后尝试"),
    N140006("140006", "客户不是586付款不能进行，使用优惠码退款"),
    N140007("140007", "输入的优惠码，已经被使用"),
    N140008("140008", "当前订单已完成返佣结算，不允许操作"),
    N140009("140009", "该笔订单可退金额不符，请重新确认金额后尝试"),


    /**
     * 审批相关
     */
    N150001("150001", "审批角色有误"),
    N150002("150002", "当前节点无人可审核"),
    N150003("150003", "当前节点您无法操作"),



    /**
     * 预设会员
     */
    N160001("160001", "查找不到预设会员信息"),
    N160002("160002", "当前状态不能回收"),


    /**
     * 赠险
     */
    N170001("170001","该用户已存在该赠险，无法新增"),
    N170002("170002","该用户不存在该赠险，无法更新"),
    /**
     * 客户成功案例
     */
    SUCCESS_CASES_CAN_NOT_ADD("250001", "同标签下已存在该素材内容,无法新增"),
    SUCCESS_CASES_CAN_NOT_UPDATE("250002", "同标签下已存在该素材内容,无法修改"),
    GET_SUCCESS_CASES_REDIS_LOCK_ERROR("250003", "获取分布式锁失败,请稍后重试"),
    ONLY_LOCK_TOP_10_CASES("250004", "只能锁前10篇成功案例"),
    TARGET_LOCATION_NOT_EXISTS("250005", "移动位置不存在"),
    MOVE_LENGTH_CAN_NOT_BIGGER_THAN_20("250006", "移动距离不能超过20"),
    TARGET_LOCATION_IS_LOCKED("250007", "目标位已被锁定位置"),
    ILLEGAL_MOVEMENT("250008", "非法移动"),

    /**
     * 测试专区
     */
    USER_NOT_EXIST("260001", "用户不存在或数据不正确"),
    OA_UN_SUBSCRIBE("260002","未取关公众号"),
    NOT_IN_ALLOW_COMPANY_LIST("260003", "该公司下账号不允许禁用"),

    /**
     * 问卷调研
     */
    SURVEY_SUBMIT_CONCURRENT("270001", "提交太频繁"),
    SURVEY_CHANGED("270002","内容发生更改，请重新填写"),
    SURVEY_NOT_EXIST("270003", "问卷不存在或已被删除"),
    SURVEY_STOPPED("270004", "SURVEY_CLOSED"),
    SURVEY_EXPORT_TOO_LARGE("27006", "问卷数据过多，导出请走BI"),

    /**
     * 文内抽奖
     */

    OUT_OF_STOCK("280001","奖品已被领完啦，已经通知代理人进行补货"),
    OPERATE_FREQUENT("280002","操作过于频繁，稍后重试"),
    STATUS_CLOSE("280003","抽奖已关闭"),
    GIFT_NOT_EXIST("280004","抽奖不存在"),
    ALREADY_PARTICIPATE("280005","已经参与过")

    ;




    private String shortCode;
    private String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "01";
    }

    @Override
    public String getShortCode() {
        return shortCode;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
