package cn.com.duiba.kjy.api.enums.autoreply;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-12-03 17:00
 * @description: 自动回复状态
 */
public enum AutoReplyStateEnum {

    /**
     * 1=启用、2=未启用、3=已过期
     */
    ENABLE(1, "启用"),
    NOT_ENABLE(2, "未启用"),
    EXPIRED(3, "已过期"),
    ;

    private Integer code;
    private String desc;

    AutoReplyStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, AutoReplyStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(AutoReplyStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static AutoReplyStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
