package cn.com.duiba.kjy.api.dto.weeklystats;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人周报统计
 * @author kjj mybatis generator 
 * 2020-07-13
 */
@Data
public class WeeklyStatsDto implements Serializable {
    private static final long serialVersionUID = 15946077242515261L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *销售id，对应tb_sellers.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *周开始时间
     * not null default = null
     */
    private Date startDate;

    /**
     *
     *周结束时间
     * not null default = null
     */
    private Date endDate;

    /**
     *
     *总线索数
     * not null default = 0
     */
    private Integer clueCount;

    /**
     *
     *线索数超过百分比
     * not null default = 0
     */
    private Integer clueSurpassPercent;

    /**
     *
     *总转发数 包括文章/名片/贺卡/邀请函/测试/抽奖等
     * not null default = 0
     */
    private Integer forwardCount;

    /**
     *
     *总素材转发数
     * not null default = 0
     */
    private Integer contentForwardCount;

    /**
     *
     *总来访数
     * not null default = 0
     */
    private Integer visitCount;
    /**
     *
     * 素材来访数
     * not null default = 0
     */
    private Integer visitContentCount;

    /**
     *
     *新增客户数
     * not null default = 0
     */
    private Integer newCustomerCount;

    /**
     *
     *转发种草素材数
     * not null default = 0
     */
    private Integer forwardGrassCount;

    /**
     *
     *转发发圈素材数
     * not null default = 0
     */
    private Integer forwardMaterialCount;

    /**
     *
     *转发名片数
     * not null default = 0
     */
    private Integer forwardCardCount;

    /**
     *
     *名片访问数
     * not null default = 0
     */
    private Integer visitCardCount;

    /**
     *
     *名片产生线索数
     * not null default = 0
     */
    private Integer cardClueCount;

    /**
     *
     *名片点赞数
     * not null default = 0
     */
    private Integer cardFavouredCount;

    /**
     *
     *关键词
     * max length = 100
     * not null default = 
     */
    private String keyword;

    /**
     *
     *正能量语录
     * max length = 255
     * not null default = 
     */
    private String positiveAna;

    /**
     *
     *首页线索数据类型
     * @see cn.com.duiba.kjy.api.enums.weekly.IndexClueStatsTypeEnum
     */
    private Integer indexClueType;

    /**
     * 查看问答数
     */
    private Integer visitQuestionCount;
    /**
     * 参与评测数
     */
    private Integer evaluatedCount;

    /**
     * 线索超过上周百分比
     */
    private Integer clueSurpassWeek;
    /**
     * 访问超过同行百分比
     */
    private Integer visitSurpassPercent;
    /**
     * 访问超过上周百分比
     */
    private Integer visitSurpassWeek;
    /**
     * 背景图
     */
    private String background;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}