package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM客户跟进进度枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:48
 */
public enum CrmSellerCustomerProgressTypeEnum {

    INIT_COMMUNICATION(1, "初步沟通"),
    EVALUATING(2, "评估中"),
    AFFIRM_COOPERATION(3, "确认合作"),
    DRAG_GROUP_ABUTMENT(4, "PM介入"),
    AFFIRM_SCHEDULE(5, "确认新排期"),
    FIRST_ONLINE(6, "直播上线"),
    COMPLETE_REPLAY(7, "上线复盘"),
    REFUSE_COLLABORATE(10, "拒绝合作"),
    FOLLOWING(11, "跟进中(1，2都归并为跟进中)"),
    INTENTION(12, "有意向"),
    AFFIRM_AMOUNT(13, "确认回款")

    ;

    private Integer code;
    private String desc;

    CrmSellerCustomerProgressTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmSellerCustomerProgressTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmSellerCustomerProgressTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmSellerCustomerProgressTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
