package cn.com.duiba.kjy.api.enums.greeting;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/1/15 15:48
 */
public enum BlessImageStateEnum {

    OPEN(1, "祝福语图片已开启"),

    CLOSE(2, "祝福语图片已关闭"),

    ;

    private Integer code;
    private String desc;

    BlessImageStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, BlessImageStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BlessImageStateEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static BlessImageStateEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

}
