package cn.com.duiba.kjy.api.remoteservice.pay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.alipay.AliPayChargeNotifyResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayChargeNotifyResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayRefundNotifyResponse;

/**
 * @author lizhi
 * @date 2020/3/3 9:08 PM
 */
@AdvancedFeignClient
public interface RemoteWxKjyNotifyService {

    /**
     * 支付结果回调
     * @param wxPayChargeNotifyResponse 支付结果，客集集支付系统回调信息
     */
    void wxPayKjyChargeNotify(WxPayChargeNotifyResponse wxPayChargeNotifyResponse);

    /**
     * 支付宝支付回调
     * @param aliPayChargeNotifyResponse
     */
    void aliPayKjyChargeNotify(AliPayChargeNotifyResponse aliPayChargeNotifyResponse);


    /**
     * 退款结果回调
     * @param notifyResponse 退款结果，客集集支付系统回调信息
     */
    void wxPayKjyRefundNotify(WxPayRefundNotifyResponse notifyResponse);

    /**
     * 口以支付结果回调
     * @param wxPayChargeNotifyResponse
     */
    void wxPayKouyiChargeNotify(WxPayChargeNotifyResponse wxPayChargeNotifyResponse);
}
