package cn.com.duiba.kjy.api.remoteservice.preInstall;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallBatchDto;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallSellerDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.preInstall.ActivateParam;
import cn.com.duiba.kjy.api.params.preInstall.AddBatchParam;
import cn.com.duiba.kjy.api.params.preInstall.LivePageQuery;
import cn.com.duiba.kjy.api.params.preInstall.PreInstallPageQuery;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @auther: xiaotian
 * @date: 2020-04-13 14:17
 * @description: 预设会员remote接口
 */
@AdvancedFeignClient
public interface RemotePreInstallService {

    /**
     * 非预置手机号，类型的激活码，在验证时使用，插入销售预置记录，以便后续激活
     * @param dto
     * @return
     */
    Long insertPreSeller(PreInstallSellerDto dto);

    /**
     * 根据激活码和代理人ID，查询或新增
     * @param dto 预设账号代理人明细
     * @return 预设账号代理人明细
     */
    PreInstallSellerDto getOrAddByBatchIdAndSellerId(PreInstallSellerDto dto);

    /**
     * 根据激活码和userId，查询或新增  第三方激活没有sellerId 所以使用此方法代替getOrAddByBatchIdAndSellerId
     * @param dto 预设账号代理人明细
     * @return 预设账号代理人明细
     */
    PreInstallSellerDto getOrAddByBatchIdAndUserId(PreInstallSellerDto dto);

    /**
     * 创建预设会员账号批次
     * @param addBatchParam
     * @return
     */
    Long createBatch(AddBatchParam  addBatchParam);


    /**
     * 获取批次详情
     * @param id
     * @return
     */
    PreInstallBatchDto  getById(Long id);

    /**
     * 修改批次数据
     * @param dto 批次数据
     * @return 处理结果
     */
    boolean updateBatch(PreInstallBatchDto dto);


    /**
     * 管理端筛选列表
     * @param livePageQuery
     * @return
     */
    Page<PreInstallBatchDto> queryPage(LivePageQuery  livePageQuery);



    /**
     * 管理端根据批次ID筛选明细列表
     * @param preInstallPageQuery
     * @return
     */
    Page<PreInstallSellerDto> querySellerPage(PreInstallPageQuery preInstallPageQuery);


    /**
     *  更新单条批次记录（对应的细化记录也要更改状态）
     * @param batchId
     * @param status
     * @return
     */
    boolean  updateStatus(Long batchId ,Integer status);



    /**
     * 更新二维码
     * @param batchId
     * @param qrCode
     * @return
     */
    boolean  updateQrCode(Long batchId ,String qrCode);


    /**
     * 根据批次ID和手机号获取详情
     * @param batchId
     * @return
     */
    PreInstallSellerDto selectByBatchAndPhone(Long batchId, String phone);


    /**
     * 根据批次ID和sellerId获取详情
     * @param batchId
     * @param sellerId
     * @return
     */
    PreInstallSellerDto selectByBatchAndSellerId(Long batchId, Long sellerId);

    /**
     * 根据批次ID和userId获取详情
     * @param batchId 批次id
     * @param userId 用户id
     * @return 详情
     */
    PreInstallSellerDto selectByBatchAndUserId(Long batchId, Long userId);

    /**
     * 查询锁定的新兵营99套餐记录
     * @param sellerId
     * @return
     */
    PreInstallSellerDto selectLockBySellerId(Long sellerId);


    /**
     * 根据详情主键ID，获取详情
     * @param id
     * @return
     */
    PreInstallSellerDto selectById(Long id);


    /**
     *  更新单条细化记录
     * @return
     */
    boolean  update(PreInstallSellerDto preInstallSellerDto);



    /**
     * 身份确认，激活用户
     * @param activateParam
     * @return
     */
    boolean  activate(ActivateParam activateParam);


    /**
     * 通过打款记录ID，获取绑定的批次列表
     * @param serialId
     * @return
     */
    List<PreInstallBatchDto> queryBySerialId(Long serialId);

    /**
     * 回收未激活的账号
     * @param preInstallId
     * @return
     */
    boolean cancelPreInstallSeller(Long preInstallId) throws KjyCenterException;

    /**
     * 根据代理人id查询激活时间
     * @param sellerIds 代理人id集合
     * @return key：代理人id value：代理人激活时间
     */
    Map<Long, Date> findActiveDateBySellerIds(List<Long> sellerIds);
}
