package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/1/8 11:09 AM
 */
public enum CompanyPayBizTypeEnum {

    RECEIVE_RED_PACKET(1, "领取节日贺卡红吧"),
    ;

    private Integer code;
    private String desc;

    CompanyPayBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, CompanyPayBizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CompanyPayBizTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static CompanyPayBizTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
