package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * 微信企业付款，返回的错误码
 * @author lizhi
 * @date 2020/1/8 12:08 PM
 */
public enum WxCompanyPayErrorCodeEnum {

    NO_AUTH("NO_AUTH", "没有该接口权限"),
    AMOUNT_LIMIT("AMOUNT_LIMIT", "金额超限"),
    PARAM_ERROR("PARAM_ERROR", "参数错误"),
    OPENID_ERROR("OPENID_ERROR", "Openid错误"),
    SEND_FAILED("SEND_FAILED", "付款错误"),
    NOT_ENOUGH("NOTENOUGH", "余额不足"),
    SYSTEM_ERROR("SYSTEMERROR", "系统繁忙，请稍后再试"),
    NAME_MISMATCH("NAME_MISMATCH", "姓名校验出错"),
    SIGN_ERROR("SIGN_ERROR", "签名错误"),
    XML_ERROR("XML_ERROR", "Post内容出错"),
    FATAL_ERROR("FATAL_ERROR", "两次请求参数不一致"),
    FREQ_LIMIT("FREQ_LIMIT", "超过频率限制，请稍后再试"),
    MONEY_LIMIT("MONEY_LIMIT", "已经达到今日付款总额上限/已达到付款给此用户额度上限"),
    CA_ERROR("CA_ERROR", "商户API证书校验出错"),
    V2_ACCOUNT_SIMPLE_BAN("V2_ACCOUNT_SIMPLE_BAN", "无法给未实名用户付款"),
    PARAM_IS_NOT_UTF8("PARAM_IS_NOT_UTF8", "请求参数中包含非utf8编码字符"),
    SEND_NUM_LIMIT("SENDNUM_LIMIT", "向用户付款的次数超限了"),
    RECV_ACCOUNT_NOT_ALLOWED("RECV_ACCOUNT_NOT_ALLOWED", "收款账户不在收款账户列表"),
    PAY_CHANNEL_NOT_ALLOWED("PAY_CHANNEL_NOT_ALLOWED", "本商户号未配置API发起能力 "),
    ;

    private String code;
    private String desc;

    WxCompanyPayErrorCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static final Map<String, WxCompanyPayErrorCodeEnum> ENUM_MAP = new HashMap<>();

    private static final Set<String> NEED_RETRY_SET = new HashSet<>();

    static{
        for(WxCompanyPayErrorCodeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
        NEED_RETRY_SET.add(PARAM_ERROR.code);
        NEED_RETRY_SET.add(SEND_FAILED.code);
        NEED_RETRY_SET.add(NOT_ENOUGH.code);
        NEED_RETRY_SET.add(SYSTEM_ERROR.code);
        NEED_RETRY_SET.add(SIGN_ERROR.code);
        NEED_RETRY_SET.add(XML_ERROR.code);
        NEED_RETRY_SET.add(FREQ_LIMIT.code);
        NEED_RETRY_SET.add(MONEY_LIMIT.code);
        NEED_RETRY_SET.add(CA_ERROR.code);
        NEED_RETRY_SET.add(PARAM_IS_NOT_UTF8.code);
        NEED_RETRY_SET.add(SEND_NUM_LIMIT.code);
        NEED_RETRY_SET.add(RECV_ACCOUNT_NOT_ALLOWED.code);
        NEED_RETRY_SET.add(PAY_CHANNEL_NOT_ALLOWED.code);
    }

    public static WxCompanyPayErrorCodeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public static boolean needRetry(String code) {
        if (code == null) {
            return false;
        }
        return NEED_RETRY_SET.contains(code);
    }

    public boolean isProcessing() {
        return this == SEND_FAILED || this == SYSTEM_ERROR;
    }

    public boolean notNeedWarn() {
        return this == V2_ACCOUNT_SIMPLE_BAN || this == FREQ_LIMIT;
    }
}
