package cn.com.duiba.kjy.api.remoteservice.dailyclockinrecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.dailyclockinrecord.DailyClockInRecordDto;
import cn.com.duiba.kjy.api.enums.dailyPosters.DailyPosterClockTypeEnum;

/**
* 早安打卡记录 Service
* @author chentiecheng
* 2020-9-27 10:06:59
*/
@AdvancedFeignClient
public interface RemoteDailyClockInRecordService {

    /**
     * 新增早、晚安打卡记录
     * @param dto
     * @return
     */
	Boolean save(DailyClockInRecordDto dto);

    /**
     * 获取代理人最后一次早安打卡记录
     * @param sellerId
     * @return
     */
    DailyClockInRecordDto getLatestClockInRecord(Long sellerId);

    /**
     * 根据销售id和打卡类型，获取最后一次打卡记录
     * @param sellerId
     * @param recordType
     * @see DailyPosterClockTypeEnum
     * @return
     */
    DailyClockInRecordDto getLatestRecordByType(Long sellerId,Integer recordType);

}
