package cn.com.duiba.kjy.api.dto.articlePrize;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 文内抽奖订单
* 2020-12-15 17:28:43
*/
@Data
public class ArticlePrizeOrderDto implements Serializable {

    /**
    * 主键
    */
    private Long id;

    /**
    * 抽奖ID 对应tb_article_custom_prize.id
    */
    private Long customPrizeId;

    /**
    * 销售员id，对应tb_seller.id
    */
    private Long sellerId;

    /**
    * 用户ID(销售员)，对应 tb_users.id
    */
    private Long sellerUserId;

    /**
    * 用户ID(访问者)，对应 tb_users.id
    */
    private Long visitorId;

    /**
    * 访问者昵称
    */
    private String visitorNickname;

    /**
    * 销售员转载内容ID，对应tb_seller_content.id
    */
    private Long scid;

    /**
    * 状态=0-未出奖，1-出奖成功
    */
    private Integer orderStatus;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

