package cn.com.duiba.kjy.api.enums.lottery;

import cn.com.duiba.kjy.api.util.BitUtils;
import cn.com.duiba.kjy.api.util.NumberUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/23 3:08 PM
 */
public enum MiddlePageSwitchEnum {

    ADD_WINNER_PAGE(0, "指定中奖人页面"),
    CHOOSE_COUPON_PAGE(1, "选择优惠券页面"),
    ;
    private Integer type;

    private String desc;

    MiddlePageSwitchEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 添加中间页
     * @param middlePageSwitch 中间页值
     * @param switchEnum 要添加的中间页枚举
     * @return 添加后的中间页值
     */
    public static Integer addPage(Integer middlePageSwitch, MiddlePageSwitchEnum switchEnum) {
        if (middlePageSwitch == null || switchEnum == null) {
            return null;
        }
        return (int) BitUtils.addBit(middlePageSwitch, switchEnum.getType());
    }

    /**
     * 删除中间页
     * @param middlePageSwitch 中间页值
     * @param switchEnum 要删除的中间页枚举
     * @return 删除后的中间页值
     */
    public static Integer removePage(Integer middlePageSwitch, MiddlePageSwitchEnum switchEnum) {
        if (middlePageSwitch == null || switchEnum == null) {
            return null;
        }
        return (int) BitUtils.removeBit(middlePageSwitch, switchEnum.getType());
    }

    /**
     * 是否包含中间页
     * @param middlePageSwitch 中间页值
     * @param switchEnum 要判断的中间页枚举
     * @return true-包含该中间页，false-不包含该中间页
     */
    public static boolean hasPage(Integer middlePageSwitch, MiddlePageSwitchEnum switchEnum) {
        if (middlePageSwitch == null || switchEnum == null) {
            return false;
        }
        return BitUtils.isTrue(middlePageSwitch, switchEnum.getType());
    }

    /**
     * 根据中间页值，获取所有页面类型
     * @param middlePageSwitch 中间页值
     * @return 包含的页面类型集合
     */
    public static List<Integer> getPages(Integer middlePageSwitch) {
        if (NumberUtil.isNullOrLteZero(middlePageSwitch)) {
            return new ArrayList<>();
        }
        List<Integer> pages = new ArrayList<>();
        for (MiddlePageSwitchEnum switchEnum : values()) {
            if(hasPage(middlePageSwitch, switchEnum)) {
                pages.add(switchEnum.getType());
            }
        }
        return pages;
    }

    /**
     * 根据页面类型集合，获取中间页值
     * @param pages 页面类型集合
     * @return 中间页值
     */
    public static int getMiddlePageSwitch(List<Integer> pages) {
        if (pages == null || pages.isEmpty()) {
            return 0;
        }
        int middlePageSwitch = 0;
        for (Integer page : pages) {
            MiddlePageSwitchEnum switchEnum = getByType(page);
            if (switchEnum == null) {
                continue;
            }
            middlePageSwitch = addPage(middlePageSwitch,switchEnum);
        }
        return middlePageSwitch;
    }

    private static final Map<Integer, MiddlePageSwitchEnum> ENUM_MAP = new HashMap<>();

    static{
        for(MiddlePageSwitchEnum switchEnum : values()){
            ENUM_MAP.put(switchEnum.getType(), switchEnum);
        }
    }

    /**
     * 根据类型获取枚举
     * @param type 类型
     * @return 枚举
     */
    public static MiddlePageSwitchEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
