package cn.com.duiba.kjy.api.params.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: linjianhui
 * @date: 2020/12/21 15:56
 * @description: 查询跟进记录参数
 */
@Data
public class CrmCustomerProgressQryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -4529932124201819739L;

    /**
     * 跟进进度类型:1初步沟通,2评估中,3确认合作,4PM介入,5确认排期,6首场上线,7完成复盘,10拒绝合作
     * @see CrmSellerCustomerProgressTypeEnum
     */
    private Integer progressType;

    /**
     * 审核状态 1:审核中 2:已撤销 3:已通过 4:已拒绝
     */
    private Integer verifyState;

    /**
     * 合作类型 1:新合作 2:长期合作
     * @see cn.com.duiba.kjy.api.enums.crm.customer.CustomerCooperateTypeEnum
     */
    private Integer cooperateType;

    /**
     * 记录开始时间
     */
    private Date createStart;

    /**
     * 记录结束时间
     */
    private Date createEnd;

    /**
     * 指定销售id
     */
    private Long crmSellerId;

    /**
     * 指定公司id
     */
    private Long crmCompanyId;

}
