package cn.com.duiba.kjy.api.enums.insureCalculate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 险种分类枚举
 * @author xiaotian
 * @date 2020/8/10 3:43 PM
 */
public enum InsuranceTypeEnum {

       /**
     * 重疾型赠险
     */
    CRITICAL_ILLNESS(1,"重疾险");

    private Integer code;
    /**
     * 枚举描述
     */
    private String desc;


    InsuranceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;

    }


    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }


    private static final Map<Integer, InsuranceTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InsuranceTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static InsuranceTypeEnum getByCode(Integer code) {
        InsuranceTypeEnum preInstallBatchStatusEnum = ENUM_MAP.get(code);
        if(Objects.isNull(preInstallBatchStatusEnum)){
            return null;
        }
        return preInstallBatchStatusEnum;
    }
}
