package cn.com.duiba.kjy.api.params.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmSellerCustomerProgressTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhanghuifeng
 * date 2020/12/6-19:00
 */
@Data
public class CrmSellerCustomerAddParam implements Serializable {

    private static final long serialVersionUID = 4122985175459947610L;
    /**
     * 对接人列表
     */
    private List<CrmCustomerAbutmentAddParam> abutmentList;

    /**
     * crm公司ID
     */
    private Long crmCompanyId;

    /**
     * 跟进进度类型:1初步沟通,2评估中,3确认合作,4PM介入,5确认排期,6首场上线,7完成复盘,10拒绝合作
     * @see CrmSellerCustomerProgressTypeEnum
     */
    private Integer progressType;

    /**
     * 备注
     *
     */
    private String remark;

    /**
     * crm销售ID
     */
    private Long crmSellerId;

    /**
     * 合作类型 1:新合作 2:长期合作
     */
    private Integer cooperateType;

    /**
     * 合作内容
     */
    private String cooperateContent;

    /**
     * 合作邮件
     */
    private String cooperateMail;

    /**
     * 跟进进度的图片
     */
    private String progressImage;

    /**
     * 跟进类型
     * @see cn.com.duiba.kjy.api.enums.crm.customer.CrmCustomerFollowTypeEnum
     */
    private Integer followType;

    /**
     * 确认合作的合作场次
     */
    private Integer cooperateTime;

    /**
     * 确认合作的合作金额
     */
    private Long cooperateAmount;

}
