package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.classify.ClassifyContentDto;
import cn.com.duiba.kjy.api.dto.classify.ClassifyDto;
import cn.com.duiba.kjy.api.params.classify.ClassifyContentAddParam;
import cn.com.duiba.kjy.api.params.classify.ClassifyContentSearchParam;

import java.util.List;

/**
 * Created by dugq on 2019-07-09.
 */
@AdvancedFeignClient
public interface RemoteClassifyContentService {
    /**
     * 查询分类详情
     * @param id
     * @return
     */
    ClassifyDto selectClassifyById(Long id);

    /**
     * 分类列表 不分页 按权重（payLoad）冲低到高排序
     * @return
     */
    List<ClassifyDto> selectClassifyList();

    /**
     * 修改分类名称
     * @param id
     * @param name
     * @return
     */
    int updateClassify(Long id, String name);

    /**
     * 查询分类的总个数
     * @return
     */
    Integer selectClassifyCount();

    /**
     * 新增分类
     * 权重默认=id 排在最后
     * @param name
     * @return  -1 标示名称重复
     */
    int insertClassify(String name);

    /**
     * 删除分类
     * 当分类下有内容时返回-1 不可删除
     * @param id
     * @return
     */
    Integer deleteClassify(Long id);

    /**
     * 将分类移动到指定排序位置
     * @param id
     * @param destination  从1开始
     * @return
     */
    Boolean sortClassify(Long id, Integer destination);

    /**
     * 查询分类下的内容详情
     * @param classifyContentId  tb_classify_content 表的id
     * @return
     */
    ClassifyContentDto selectContentByClassifyContentId(Long classifyContentId);

    /**
     * 查询分类下的内容列表 支持分页
     * classifyId can not be null
     * @param param
     * @return
     */
    List<ClassifyContentDto> selectContentByClassify(ClassifyContentSearchParam param);

    /**
     * 新增内容到分类下
     * 包含一些保存在内容表上的字段，但只在首页使用
     * companyId 自动填充为content的companyId
     * @param param
     * @return  -1 内容不存在 -2：分类不存在
     */
    Long addContent2Recommend(ClassifyContentAddParam param) throws KjyCenterException;

    /**
     * 跟新首页推荐内容 包含内容上的自定义标签
     * 状态跟新，请使用updateClassifyContentStatus独立方法，减少额外处理
     * @param param
     * @return
     */
    int updateRecommendContent(ClassifyContentAddParam param);

    /**
     * 给分类下的内容进行排序
     * @param classifyContentId  关系表id
     * @param destination  排序位置，不是权重。 从1开始
     * @param companyId  支持公司作为参数
     * @return
     */
    Boolean sortClassifyContent(Long classifyContentId, int destination, Long companyId) throws KjyCenterException;

    /**
     * 移除分类下的某个内容
     * @param classifyContentId
     * @return
     */
    Integer deleteClassifyContent(Long classifyContentId);

    /**
     * 跟新内容状态 只是首页是否展示的状态，和内容本身的状态是分割开的
     * @param classifyContentId
     * @param open   false :关闭 true : 开启
     * @return
     */
    Boolean updateClassifyContentStatus(Long classifyContentId,Boolean open);

    /**
     * 查询内容下的总个数
     * @param param
     * @return
     */
    Integer selectClassifyContentCount(ClassifyContentSearchParam param);

    Long historyTotalNum(Long classifyId);

    Integer atomicIncreaseClickTimes(Long id);

    ClassifyContentDto selectByContentId(Long contentId);

    List<ClassifyContentDto> selectByContentIds(List<Long> contentId, Boolean isOpen);

}
