package cn.com.duiba.kjy.api.remoteservice.kouyi;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.kouyi.KouyiPayRecordDto;
import cn.com.duiba.kjy.api.params.kouyi.KouyiPayRecordParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-09-09 09:42
 * @descript 口以支付记录remoteService
 */
@AdvancedFeignClient
public interface RemoteKouyiPayRecordService {

    /**
     * 保存订单
     * @param kouyiPayRecordDto
     * @return
     */
    int savePayRecord(KouyiPayRecordDto kouyiPayRecordDto);

    /**
     * 更新订单状态
     * @param kouyiPayRecordDto
     * @return
     */
    int updatePayRecord(KouyiPayRecordDto kouyiPayRecordDto);

    /**
     * 根据tradeNo更新wxTradeNo
     * @param tradeNo
     * @param wxTradeNo
     * @return
     */
    boolean updateWxTradNoByNo(String tradeNo, String wxTradeNo);

    /**
     * 根据
     * @param bizIds
     * @param payStatus
     * @return
     */
    List<Long> findBizIdByBizIdsAndPayStatus(List<Long> bizIds, Integer payStatus, Long userId);

    /**
     * 查询课程列表
     * @param param
     * @return
     */
    List<Long> findBizIdByParam(KouyiPayRecordParam param);

    /**
     * 查询课程总数
     * @param param
     * @return
     */
    int countByParam(KouyiPayRecordParam param);

    /**
     * 根据交易号查询
     * @param tradeNo
     * @return
     */
    KouyiPayRecordDto findByTradeNo(String tradeNo);

    /**
     * 根据参数查询列表
     * @param payRecordParam
     * @return
     */
    List<KouyiPayRecordDto> findByParam(KouyiPayRecordParam payRecordParam);

    /**
     * 批量更新记录支付状态
     * @param ids
     * @param code
     * @return
     */
    int batchUpdateRecordPayStatus(List<Long> ids, Integer code);
}
