package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 客户来源字段枚举
 */
public enum CrmCustomerFromEnum {

    /**
     * 客户来源
     */
    STRANGE_VISIT(1, "陌拜"),
    RECOMMEND(2, "转介绍"),
    ACCORD_CLUE(3, "主动线索")
    ;


    private final Integer code;
    private final String desc;

    CrmCustomerFromEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, CrmCustomerFromEnum> ENUM_MAP = new HashMap<>();

    static {
        for (CrmCustomerFromEnum item : CrmCustomerFromEnum.values()) {
            ENUM_MAP.put(item.getCode(), item);
        }
    }

    public static CrmCustomerFromEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static Boolean containsCode(Integer code) {
        return Objects.nonNull(ENUM_MAP.get(code));
    }

}
