package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/1/6 4:04 PM
 */
public enum ChargeStatusEnum {

    //兑吧状态
    INIT(0, "初始化状态"),
    ORDER_SUCCESS(1,"第三方支付收单成功"),
    ORDER_FAIL(2, "第三方支付收单失败"),
    PAY_SUCCESS(4, "支付成功"),
    PAY_FAIL(3, "支付失败"),
    PAY_REVERSED(5, "支付取消"),
    REFUNDING(6, "退款中"),
    REFUND_SUCCESS(7, "退款成功"),
    REFUND_FAIL(8, "退款失败"),

    //客集集自定义状态
    KJJ_CREATE_PAY_RECORD_FAIL(21, "生成支付记录失败"),
    KJJ_DUIBA_ERROR(22, "调用第三方失败")
    ;

    private Integer code;
    private String desc;

    ChargeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, ChargeStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ChargeStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static ChargeStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static boolean isPaySuccess(Integer code) {
        ChargeStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == PAY_SUCCESS;
    }

    public static boolean isPayFail(Integer code) {
        ChargeStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == KJJ_CREATE_PAY_RECORD_FAIL || statusEnum == KJJ_DUIBA_ERROR
                || statusEnum == ORDER_FAIL || statusEnum == PAY_FAIL;
    }

    public static boolean canCancel(Integer code) {
        ChargeStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == INIT || statusEnum == ORDER_SUCCESS || statusEnum == PAY_REVERSED;
    }

    public static boolean isPayCancel(Integer code) {
        ChargeStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == PAY_REVERSED;
    }

    public static boolean isRefund(Integer code) {
        ChargeStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == REFUNDING || statusEnum == REFUND_FAIL || statusEnum == REFUND_SUCCESS;
    }

    public static boolean isPayFinal(Integer code) {
        ChargeStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return isPayFail(code) || isPaySuccess(code) || isPayCancel(code) || isRefund(code);
    }
}
