package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 扩展字段业务类型枚举
 */
public enum CrmCommonExtBizEnum {

    /**
     * 扩展字段业务类型
     */
    SELLER_DAILY_PAPER(1, "销售日报"),
    CUSTOMER_PROGRESS(2, "跟进记录")
    ;


    private Integer code;
    private String desc;

    CrmCommonExtBizEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, CrmCommonExtBizEnum> ENUM_MAP = new HashMap<>();

    static {
        for (CrmCommonExtBizEnum item : CrmCommonExtBizEnum.values()) {
            ENUM_MAP.put(item.getCode(), item);
        }
    }

    public static CrmCommonExtBizEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

}
