package cn.com.duiba.kjy.api.enums.crm;

import com.google.common.collect.Maps;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * crm通用扩展表所存字段枚举
 */
public enum CrmCommonExtColumnEnum {

    /**
     * 扩展字段
     */
    BIZ_CITY(1, "bizCity"),
    TODAY_SCHEDULED_CUSTOMER(2, "todayScheduledCustomer"),
    INTENTION_TOPIC(3, "intentionTopic"),
    INTENTION_SCHEDULE(4, "intentionSchedule"),
    BUDGET(5, "budget"),
    OBJECTION(6, "objection"),
    FOLLOW_PLAN(7, "followPlan")
    ;


    private Integer code;
    private String paramName;

    CrmCommonExtColumnEnum(Integer code, String paramName) {
        this.code = code;
        this.paramName = paramName;
    }

    public Integer getCode() {
        return code;
    }

    public String getParamName() {
        return paramName;
    }

    private static final Map<Integer, CrmCommonExtColumnEnum> CODE_MAP = new HashMap<>();
    private static final Map<String, CrmCommonExtColumnEnum> PARAM_NAME_MAP = new HashMap<>();

    static {
        for (CrmCommonExtColumnEnum item : CrmCommonExtColumnEnum.values()) {
            CODE_MAP.put(item.getCode(), item);
            PARAM_NAME_MAP.put(item.getParamName(), item);
        }
    }

    public static CrmCommonExtColumnEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return CODE_MAP.get(code);
    }

    public static CrmCommonExtColumnEnum getByParamName(String paramName) {
        if (paramName == null) {
            return null;
        }
        return PARAM_NAME_MAP.get(paramName);
    }

}
