package cn.com.duiba.kjy.api.enums.invitationLetter;

import cn.com.duiba.kjy.api.enums.animation.AnimationBizTypeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/17 2:39 PM
 */
public enum InvitationTypeEnum {

    POSTER(1, "邀请函（海报）"),
    ANIMATION(2, "邀请函（动画）"),
    ;

    private Integer type;

    private String desc;

    InvitationTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, InvitationTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InvitationTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static InvitationTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据动画工具业务类型，获取邀请函类型
     * @param bizType 动画工具业务类型
     * @return 是否有效
     */
    public static InvitationTypeEnum getByAnimationBizType(Integer bizType) {
        AnimationBizTypeEnum bizTypeEnum = AnimationBizTypeEnum.getByType(bizType);
        if (bizTypeEnum == null) {
            return null;
        }
        if (bizTypeEnum.equals(AnimationBizTypeEnum.INVITATION_LETTER_POSTER)) {
            return POSTER;
        }
        if (bizTypeEnum.equals(AnimationBizTypeEnum.INVITATION_LETTER_ANIMATION)) {
            return ANIMATION;
        }

        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
