package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerVisitRelationDto;
import cn.com.duiba.kjy.api.params.seller.SellerVisitRelationQueryParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/6/15 14:22
 */
@AdvancedFeignClient
public interface RemoteSellerVisitRelationService {

    /**
     * 根据参数查询列表
     * @param param 查询参数
     * @return 访客关系链列表数据
     */
    List<SellerVisitRelationDto> findListByParam(SellerVisitRelationQueryParam param);

    /**
     * 根据参数统计
     * @param param 参数参数
     * @return 符合条件的总数
     */
    Integer countByParam(SellerVisitRelationQueryParam param);
}
