package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * crm销售客户对接人职位枚举
 * @author zhanghuifeng
 * date 2020/12/4-18:01
 */
public enum CrmAbutmentPositionTypeEnum {

    BRANCH_COMPANY_GM(1, "分公司总经理"),
    PLANNING_GM(2,"企划总"),
    TRAIN_GM(3,"培训总"),
    SELLER(4,"支公司总经理"),
    AREA_GM(5,"区域总"),
    ORGANIZATION_GM(6,"机构总"),
    BRANCH_MANAGER(7,"部经理"),
    GROUP_TEACH(8,"组训"),
    PROGRAM_ABUTMENT(9,"项目对接人"),
    OTHER(10,"其他"),
    PERSONAL_INSURANCE_GM(11,"个险总"),
    ;

    private Integer code;
    private String desc;

    CrmAbutmentPositionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmAbutmentPositionTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmAbutmentPositionTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmAbutmentPositionTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
