package cn.com.duiba.kjy.api.remoteservice.greeting;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.greeting.SellerGreetingCardStatisticDto;

import java.util.List;

/**
 * 代理人节日贺卡数据统计服务
 * @author 刘超
 * @date 2019/12/18 17:58
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteSellerGreetingCardStatisticService {

    /**
     * 根据节日贺卡配置id查询统计数据
     * @param confId 节日贺卡配置id
     * @return 根据主键查询
     */
    SellerGreetingCardStatisticDto findByConfId(Long confId);


    /**
     * 根据贺卡配置ID集合查询统计数据
     * @param confIds 贺卡配置ID
     * @return 代理人贺卡配置统计信息集合
     */
    List<SellerGreetingCardStatisticDto> findByConfIds(List<Long> confIds);

}
