package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerRelationStatDto;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerRelationStatParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-06-17 10:31
 * @descript 代理人访客关系排行统计 remoteService
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerRelationStatService {

    /**
     * 根据代理人id和客户的用户id查询
     * @param sellerId
     * @param forwardUserId
     * @return
     */
    SellerCustomerRelationStatDto getBySellerIdAndForwardUserId(Long sellerId, Long forwardUserId);


    /**
     * 根据代理人id统计比totalNum大的客户数
     * @param sellerId
     * @param totalNum
     * @return
     */
    Integer countBySellerIdAndTotalNum(Long sellerId, Long totalNum);

    /**
     * 根据代理人总数查询
     * @param sellerId
     * @return
     */
    Integer countBySellerId(Long sellerId);

    /**
     * 根据param查询列表
     * @param param
     * @return
     */
    List<SellerCustomerRelationStatDto> listByParam(SellerCustomerRelationStatParam param);

}
