package cn.com.duiba.kjy.api.dto.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmAbutmentPositionTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
* 销售CRM客户对接人信息dto
*/
@Data
public class CrmSellerCustomerAbutmentDto implements Serializable {

    private static final long serialVersionUID = -6114958116319699013L;
    /**
    * 主键
    */
    private Long id;

    /**
    * tb_crm_company表主键ID
    */
    private Long crmCompanyId;

    /**
    * 对接人名称
    */
    private String abutmentName;

    /**
    * 职位类型，1分公司总经理,2企划总,3培训总,4支公司总经理,5区域总,6机构总,7部经理,8组训,9项目对接人,10其他
     * @see CrmAbutmentPositionTypeEnum
    */
    private Integer positionType;

    /**
    * 手机号
    */
    private String phoneNum;

    /**
    * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
    */
    private Integer deleted;

    /**
     * 微信号
     */
    private String wechatNum;

}

