package cn.com.duiba.kjy.api.dto.billing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 代理人开单打卡补卡券领取记录表
*/
@Data
public class BillingClockReissueTicketDrawDto implements Serializable {

    private static final long serialVersionUID = 2062999716114379136L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 代理人ID
    */
    private Long sellerId;

    /**
    * 补卡券配置ID，tb_billing_clock_reissue_ticket_conf主键ID
    */
    private Long reissueTicketConfId;

    /**
    * 领取时间
    */
    private Date drawTime;

    /**
    * 领取状态，1待领取 2已领取
     * @see cn.com.duiba.kjy.api.enums.billing.BillingClockDrawStateEnum
    */
    private Integer drawState;

    /**
     * 领取来源
     * @see cn.com.duiba.kjy.api.enums.billing.BillingClockDrawSourceEnum
     */
    private Integer drawSource;
}

