package cn.com.duiba.kjy.api.dto.redpacket;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2020/1/8 11:46 AM
 */
@Data
public class WxCompanyPayCreateDto implements Serializable {

    private static final long serialVersionUID = -1193374347930021453L;

    /**
     * 企业付款金额，单位为分
     */
    private Integer amount;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String mchAppId;

    /**
     * 用户的标识，对公众号唯一
     */
    private String openId;

    /**
     * 描述
     */
    private String description;

    /**
     * 用户真实ip
     */
    private String spbillCreateIp;

    /**
     * 使用企业付款的业务类型
     * @see cn.com.duiba.kjy.api.enums.pay.CompanyPayBizTypeEnum
     */
    private Integer companyPayBizType;

    /**
     * 使用企业付款业务对应表的主键
     */
    private Long companyPayBizId;
}
