package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/23 3:06 PM
 */
public enum LotteryRuleEnum {

    RATE(0, "概率"),
    PRIORITY(1, "优先级"),
    ;

    private Integer rule;
    private String desc;

    LotteryRuleEnum(Integer rule, String desc) {
        this.rule = rule;
        this.desc = desc;
    }

    private static final Map<Integer, LotteryRuleEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LotteryRuleEnum ruleEnum : values()){
            ENUM_MAP.put(ruleEnum.getRule(), ruleEnum);
        }
    }

    public static LotteryRuleEnum getByRule(Integer rule) {
        if (rule == null) {
            return null;
        }
        return ENUM_MAP.get(rule);
    }

    public Integer getRule() {
        return rule;
    }

    public String getDesc() {
        return desc;
    }
}
