package cn.com.duiba.kjy.api.enums.promotion;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 优惠码类型
 *
 * @author xuzhigang
 * @date 2021/4/12 7:46 下午
 **/
@Getter
@AllArgsConstructor
public enum PromotionCodeTypeEnum {
    /**
     * 未知
     */
    TYPE_0(0, 0, 0, "未知,展示实际价格"),

    /**
     * 158/半年
     */
    TYPE_1(1, 15800, 6, "158/半年"),

    /**
     * 186/半年
     */
    TYPE_2(2, 18600, 6, "186/半年"),

    /**
     * 286/一年
     */
    TYPE_3(3, 28600, 12, "286/一年"),

    /**
     * 386/一年
     */
    TYPE_4(4, 38600, 12, "386/一年"),

    /**
     * 365/一年
     */
    TYPE_5(5, 36500, 12, "365/一年"),
    ;

    /**
     * 优惠码类型
     */
    private final Integer type;

    /**
     * 价格/分
     */
    private final Integer price;

    /**
     * 会员时长/月
     */
    private final Integer validityDuration;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, PromotionCodeTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        Arrays.stream(values()).forEach(promotionCodeTypeEnum -> ENUM_MAP.put(promotionCodeTypeEnum.getType(), promotionCodeTypeEnum));
    }

    /**
     * 根据优惠码类型查询优惠码信息
     */
    public static PromotionCodeTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

    /**
     * 是否是未知类型 未知类型取实际价格
     */
    public static boolean isUnknownType(Integer type) {
        return TYPE_0.getType().equals(type);
    }
}
