package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019-06-05
 */
public enum ContentSellerRelationTypeEnum {
    //内容和销售员关系的类型
    SELLER_IMPORT(1, "销售员上传")
    ;
    private int code;

    private String desc;

    ContentSellerRelationTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static ContentSellerRelationTypeEnum getByCode(int code) {
        for (ContentSellerRelationTypeEnum enumVal : ContentSellerRelationTypeEnum.values()) {
            if (enumVal.getCode()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        ContentSellerRelationTypeEnum byCode = getByCode(code);
        if (Objects.isNull(byCode)) {
            return "";
        }
        return byCode.getDesc();
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
