package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.api.constant.KjyRuntimeException;
import cn.com.duiba.kjy.api.util.ErrorCode;

/**
 * Created by dugq on 2020-06-17.
 * 环境枚举
 */
public enum EvnTypeEnum {
    DEV(1,"开发环境"),
    TEST(2,"测试环境"),
    PRE(3,"预发环境"),
    RROD(4,"线上环境")
    ;
    /**
     * 环境类型
     */
    private Integer type;
    /**
     * 环境描述
     */
    private String desc;

    EvnTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static EvnTypeEnum getCurrentEvn(){
        if (SpringEnvironmentUtils.isProdEnv()){
            return RROD;
        }
        if (SpringEnvironmentUtils.isPreEnv()){
            return PRE;
        }
        if (SpringEnvironmentUtils.isTestEnv()){
            return TEST;
        }
        if (SpringEnvironmentUtils.isDevEnv()){
            return DEV;
        }
        throw new KjyRuntimeException(ErrorCode.SYSTEM);
    }

}
