package cn.com.duiba.kjy.api.enums.promotion;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 优惠码类型
 *
 * @author xuzhigang
 * @date 2021/4/12 7:46 下午
 **/
@Getter
@AllArgsConstructor
public enum PromotionCodeTypeEnum {
    /**
     * 未知
     */
    TYPE_0(0, 0, 0, false, "未知,展示实际价格"),

    /**
     * 158/半年
     */
    TYPE_1(1, 15800, 6, false, "半年会员(￥158)"),

    /**
     * 186/半年
     */
    TYPE_2(2, 18600, 6, true, "半年会员(￥186)"),

    /**
     * 286/一年
     */
    TYPE_3(3, 28600, 12, true, "一年会员(￥286)"),

    /**
     * 386/一年
     */
    TYPE_4(4, 38600, 12, false, "一年会员(￥386)"),

    /**
     * 365/一年
     */
    TYPE_5(5, 36500, 12, true, "一年会员(¥365--180天打卡返现)"),
    ;

    /**
     * 优惠码类型
     */
    private final Integer type;

    /**
     * 价格/分
     */
    private final Integer price;

    /**
     * 会员时长/月
     */
    private final Integer validityDuration;

    /**
     * 是否启用
     */
    private final boolean enable;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, PromotionCodeTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        Arrays.stream(values()).forEach(promotionCodeTypeEnum -> ENUM_MAP.put(promotionCodeTypeEnum.getType(), promotionCodeTypeEnum));
    }

    /**
     * 根据优惠码类型查询优惠码价格和会员时长 未知类型返回null
     */
    public static PromotionCodeTypeEnum getByType(Integer type) {
        if (isUnknownType(type)) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 获取正在使用的类型
     */
    public static List<PromotionCodeTypeEnum> getEnableList() {
        return Arrays.stream(PromotionCodeTypeEnum.values())
                .filter(promotionCodeTypeEnum -> promotionCodeTypeEnum.enable)
                .collect(Collectors.toList());
    }

    /**
     * 是否是未知类型 未知类型取实际价格
     */
    public static boolean isUnknownType(Integer type) {
        return TYPE_0.getType().equals(type) || Objects.isNull(type);
    }
}
