package cn.com.duiba.kjy.api.enums.survey;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

import java.util.Objects;

/**
 * 问题类型
 * @author liuchao1
 */
@AllArgsConstructor
@Getter
public enum SurveyQuestionTypeEnum {
    FEEDBACK("feedback", "反馈", false, true),
    RADIO("radio", "单选", true, false),
    TEXT("text", "单行", false, false),
    TEXT_AREA("textarea", "多行文本", false, false),
    CHECKBOX("checkbox", "多选", true, false),
    GRADE("grade", "打分", true, false),
    ;

    private final String type;
    private final String msg;
    /**
     * 是否必须有option
     */
    private final boolean requireOption;

    /**
     * 允许先提交
     */
    private final boolean allowEarlierSubmit;

    public static SurveyQuestionTypeEnum getQuestionTypeEnumByType(String type) {
        for (SurveyQuestionTypeEnum value : SurveyQuestionTypeEnum.values()) {
            if (Objects.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }

}
