package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.SellerClockInTaskProgressDto;

import java.util.Date;
import java.util.List;

/**
 * 打卡任务进度
 *
 * @author xuzhigang
 * @date 2021/4/14 10:58 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerClockInTaskProgressService {
    /**
     * 根据代理人id查询当日每个任务进度
     *
     * @param clockInProgressId 任务总进度id
     * @param doneTime 完成时间
     * @return 任务进度列表
     */
    List<SellerClockInTaskProgressDto> getBySellerClockDoneTime(Long clockInProgressId, Date doneTime);
}
