package cn.com.duiba.kjy.api.dto.autoreply;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author linjianhui
 * @description 公众号接收到文本消息
 * @date 2020-03-07 11:36
 */
@Data
@ToString
public class ReceiveTextDto  implements Serializable {
    private static final long serialVersionUID = 481225807396225026L;
    /**
     * 开发者微信号
     */
    private String oaId;

    /**
     * 发送方帐号（一个OpenID）
     */
    private String openId;

    /**
     * 消息创建时间 （整型）
     */
    private Long createTime;

    /**
     * 消息类型
     */
    private String msgType;

    /**
     * 消息id，64位整型
     */
    private Long msgId;

    /**
     * 用户回复内容
     */
    private String content;

}
