package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoRecordDto;

/**
 * 代理人AI跟拍视频记录表 Service
 *
 * @author chentiecheng
 * 2021-4-26 16:23:49
 */
@AdvancedFeignClient
public interface RemoteAiVideoRecordService {
    /**
     * 新增记录
     *
     * @param dto 视频记录
     * @return 执行结果
     */
    int save(AiVideoRecordDto dto);

    /**
     * 更新状态
     *
     * @param videoStatus 视频状态 {@link cn.com.duiba.kjy.api.enums.aivideo.AiVideoStatusEnum}
     * @param streamId    流id
     * @return 执行结果
     */
    int updateStatusByStreamId(Integer videoStatus, Long streamId);

    /**
     * 开始录制
     *
     * @param streamId 流id
     * @return 执行结果
     */
    int startByStreamId(Long streamId);

    /**
     * 根据id更新
     *
     * @param dto 视频记录
     * @return 执行结果
     */
    int updateById(AiVideoRecordDto dto);

    /**
     * 根据id获取
     *
     * @param streamId 主键id
     * @return 视频记录
     */
    AiVideoRecordDto selectByStreamId(Long streamId);

    /**
     * 根据userId查询未结束视频记录
     *
     * @param userId 用户id
     * @return 视频记录
     */
    AiVideoRecordDto selectNotEndVideoRecord(Long userId);
}
