package cn.com.duiba.kjy.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.reward.RewardActivityStatsDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-16 13:39
 * @descript 活动统计 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardActivityStatsApiService {

    /**
     * 根据活动ids查询列表
     * @param activityIds 活动ids
     * @return 列表数据
     */
    List<RewardActivityStatsDto> findByActivityIds(List<Long> activityIds);

    /**
     * 修改中奖人数
     * @param activityId 活动id
     * @param winnerNum 指定中奖人数
     * @return 操作结果
     */
    boolean updateWinnerNumById(Long activityId,Integer winnerNum);

    /**
     * 初始化活动统计数据
     * @param dto 活动id
     * @return 操作结果
     */
    int save(RewardActivityStatsDto dto);

    /**
     * 根据活动id查询数据
     * @param activityId 活动id
     * @return 数据
     */
    RewardActivityStatsDto selectByActivityId(Long activityId);

    /**
     * 增加参与人数
     * @param activityId 活动id
     * @param increaseNum 增长数量
     * @return 增长结果
     */
    boolean increaseTotalNum(Long activityId, int increaseNum);

    /**
     * 增加中奖人数
     * @param activityId 活动id
     * @param increaseNum 增长数量
     * @return 结果
     */
    boolean increaseWinnerNum(Long activityId, int increaseNum);
}
