package cn.com.duiba.kjy.api.remoteservice.wx.menu;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.wx.menu.WxMenuDto;
import cn.com.duiba.kjy.api.params.wx.menu.WxMenuSearchParam;

import java.util.List;

/**
 * 微信公众号菜单
 * @author lizhi
 * @date 2020/10/10 2:33 PM
 */
@AdvancedFeignClient
public interface RemoteOaWxMenuService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 微信公众号菜单集合
     */
    List<WxMenuDto> selectList(WxMenuSearchParam param);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 微信公众号菜单集合
     */
    List<WxMenuDto> selectPage(WxMenuSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxMenuSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信公众号菜单
     */
    WxMenuDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信公众号菜单
     * @return 执行结果
     */
    int insert(WxMenuDto dto);

    /**
     * 更新
     * @param dto 微信公众号菜单
     * @return 执行结果
     */
    int update(WxMenuDto dto);

    /**
     * 更新状态
     * @param id 主键
     * @param status 状态
     * @see cn.com.duiba.kjy.api.enums.wx.WxMenuStatusEnum
     * @param expectedStatus 预期的更新前状态
     * @see cn.com.duiba.kjy.api.enums.wx.WxMenuStatusEnum
     * @return 执行结果
     */
    int updateStatus(Long id, Integer status, Integer expectedStatus);

    /**
     * 将公众号下正在启用的菜单下架
     * @param oaId 公众号ID
     * @return 执行结果
     */
    int offTheOnDefaultMenu(Long oaId);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
